IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO')
BEGIN
	DROP TRIGGER TRG_EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO
END
GO
CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO] ON [dbo].[EST_NF_ENT_DANFE_PROVISORIO] FOR  UPDATE AS
BEGIN
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ
(CD_CTR,
TIPO_BLQ,
DT_LIBERACAO,
CD_USU_LIB,
OBS_LIB,
DT_HR_CAD)
SELECT
	i.CD_CTR,
	1,
	CONVERT(CHAR(10),GETDATE(),112),
	i.CD_USU_LIBEROU_ENTRADA,
	'NOTA FISCAL 100% PBM ENTRADA LIBERADA',
	GETDATE()
FROM
	INSERTED i LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_TIPO_BLQ L ON
	i.CD_CTR= L.CD_CTR AND
	1 = L.TIPO_BLQ
WHERE
	L.CD_CTR IS NULL
	AND i.CD_USU_LIBEROU_ENTRADA<>0
END

GO

ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO] ENABLE TRIGGER [TRG_EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO]
GO


